<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\General_Setting;
use App\Models\Common;
use App\Models\Reward_Setting;
use Illuminate\Http\Request;
use Exception;

class CoinSettingController extends Controller
{
    public $common;
    public function __construct()
    {
        $this->common = new Common;
    }

    public function index()
    {
        try {

            $params['setting_data'] = Setting_Data();

            $params['reward_setting'] = Reward_Setting::get();
            foreach ($params['reward_setting'] as $row) {
                $params['reward_setting'][$row->key] = $row->value;
            }
            return view('admin.coin_setting.index', $params);
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function spin_wheel(Request $request)
    {
        try {

            $data = $request->all();
            $data['1'] = $data['1'] ?? 0;
            $data['2'] = $data['2'] ?? 0;
            $data['3'] = $data['3'] ?? 0;
            $data['4'] = $data['4'] ?? 0;
            $data['5'] = $data['5'] ?? 0;
            $data['6'] = $data['6'] ?? 0;
            $data['7'] = $data['7'] ?? 0;
            $data['8'] = $data['8'] ?? 0;

            foreach ($data as $key => $value) {

                $setting = Reward_Setting::where('key', $key)->first();
                if (isset($setting['id'])) {
                    $setting['value'] = $value;
                    $setting->save();
                }
            }
            return response()->json(['status' => 200, 'success' => __('label.setting_save_successfully')]);
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function daily_reward(Request $request)
    {
        try {

            $data = $request->all();
            $data['day-1'] = $data['day-1'] ?? 0;
            $data['day-2'] = $data['day-2'] ?? 0;
            $data['day-3'] = $data['day-3'] ?? 0;
            $data['day-4'] = $data['day-4'] ?? 0;
            $data['day-5'] = $data['day-5'] ?? 0;
            $data['day-6'] = $data['day-6'] ?? 0;
            $data['day-7'] = $data['day-7'] ?? 0;

            foreach ($data as $key => $value) {

                $setting = Reward_Setting::where('key', $key)->first();
                if (isset($setting['id'])) {
                    $setting['value'] = $value;
                    $setting->save();
                }
            }
            return response()->json(['status' => 200, 'success' => __('label.setting_save_successfully')]);
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function ads_free_coin(Request $request)
    {
        try {

            $data = $request->all();
            $data['ads_free_coin'] = $data['ads_free_coin'] ?? 0;

            foreach ($data as $key => $value) {

                $setting = Reward_Setting::where('key', $key)->first();
                if (isset($setting['id'])) {
                    $setting['value'] = $value;
                    $setting->save();
                }
            }
            return response()->json(['status' => 200, 'success' => __('label.setting_save_successfully')]);
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function withdrawal(Request $request)
    {
        try {

            $data = $request->all();
            $data['withdrawal_coin_status'] = $data['withdrawal_coin_status'] ?? 0;
            $data['min_withdrawal_coin'] = $data['min_withdrawal_coin'] ?? 0;
            $data['earning_per_coin'] = $data['earning_per_coin'] ?? 0;
            $data['coin_per_amount'] = $data['coin_per_amount'] ?? 0;

            foreach ($data as $key => $value) {
                $setting = General_Setting::where('key', $key)->first();
                if (isset($setting->id)) {
                    $setting->value = $value;
                    $setting->save();
                }
            }
            return response()->json(['status' => 200, 'success' => __('label.setting_save_successfully')]);
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
    public function coin_share(Request $request)
    {
        try {
            $data = $request->all();
            $data['min_coin_share'] = $data['min_coin_share'] ?? 0;

            foreach ($data as $key => $value) {

                $setting = General_Setting::where('key', $key)->first();
                if (isset($setting['id'])) {
                    $setting['value'] = $value;
                    $setting->save();
                }
            }
            return response()->json(['status' => 200, 'success' => __('label.setting_save_successfully')]);
        } catch (Exception $e) {
            return response()->json(['status' => 400, 'errors' => $e->getMessage()]);
        }
    }
}
